/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.item.api.itemgroup;

import io.github.fabricators_of_create.porting_lib.item.api.extensions.CreativeModeTabExt;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1761;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class PortingLibCreativeTab {
    public static PortingLibCreativeTabBuilder builder() {
        return new PortingLibCreativeTabBuilder();
    }

    public static class PortingLibCreativeTabBuilder
    extends class_1761.class_7913 {
        public static final class_2960 CREATIVE_TABS_LOCATION = new class_2960("textures/gui/container/creative_inventory/tabs.png");
        private boolean hasDisplayName = false;
        private class_2960 tabsImage = CREATIVE_TABS_LOCATION;
        private int labelColor = 0x404040;
        private int slotColor = -2130706433;
        private final List<class_2960> tabsBefore = new ArrayList<class_2960>();
        private final List<class_2960> tabsAfter = new ArrayList<class_2960>();

        public PortingLibCreativeTabBuilder() {
            super(null, -1);
        }

        public PortingLibCreativeTabBuilder title(class_2561 displayName) {
            this.hasDisplayName = true;
            return (PortingLibCreativeTabBuilder)super.method_47321(displayName);
        }

        public class_1761 method_47324() {
            if (!this.hasDisplayName) {
                throw new IllegalStateException("No display name set for ItemGroup");
            }
            class_1761 tab = super.method_47324();
            ((CreativeModeTabExt)tab).setPortingData(new TabData(this.tabsImage, this.labelColor, this.slotColor, this.tabsBefore, this.tabsAfter));
            return tab;
        }

        public PortingLibCreativeTabBuilder withTabsImage(class_2960 tabsImage) {
            this.tabsImage = tabsImage;
            return this;
        }

        public PortingLibCreativeTabBuilder withLabelColor(int labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public PortingLibCreativeTabBuilder withSlotColor(int slotColor) {
            this.slotColor = slotColor;
            return this;
        }

        public PortingLibCreativeTabBuilder withTabsBefore(class_2960 ... tabs) {
            this.tabsBefore.addAll(List.of(tabs));
            return this;
        }

        public PortingLibCreativeTabBuilder withTabsAfter(class_2960 ... tabs) {
            this.tabsAfter.addAll(List.of(tabs));
            return this;
        }

        @SafeVarargs
        public final PortingLibCreativeTabBuilder withTabsBefore(class_5321<class_1761> ... tabs) {
            Stream.of(tabs).map(class_5321::method_29177).forEach(this.tabsBefore::add);
            return this;
        }

        @SafeVarargs
        public final PortingLibCreativeTabBuilder withTabsAfter(class_5321<class_1761> ... tabs) {
            Stream.of(tabs).map(class_5321::method_29177).forEach(this.tabsAfter::add);
            return this;
        }
    }

    public record TabData(class_2960 tabsImage, int labelColor, int slotColor, List<class_2960> tabsBefore, List<class_2960> tabsAfter) {
    }
}

